#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcl.h>
#include <tk.h>

#include "global.h"
#include "attribute.h"
#include "tcl_interface.h"


int num_attributes1(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
Tcl_SetObjResult(interp,Tcl_NewIntObj(num_attributes()));
return TCL_OK;
}

int attribute_name(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: attribute_name requires one argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: attribute_name: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_attributes()){
	Tcl_AppendResult(interp,"ERROR: attribute_name: index too big",NULL);
	return TCL_ERROR;
	}	
Tcl_AppendResult(interp,get_attribute(i)->name,NULL);
return TCL_OK;
}


int find_attribute(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: find_attribute requires one argument",NULL);
	return TCL_ERROR;
	}
for(i=0;i<num_attributes();i++)
	if(!strcmp(get_attribute(i)->name,argv[1])){
		Tcl_SetObjResult(interp,Tcl_NewIntObj(i));
		return TCL_OK;
		}	
Tcl_SetObjResult(interp,Tcl_NewIntObj(-1));
return TCL_OK;
}
